--SCRIPT:  DW_SCHEDULE_BATCH_JOBS.SQL
--script to re-set batch jobs.  DW_PROCESS_BATCH_REQUESTS, DW_REPORT_PENDING_REQUESTS and DW_MONTHLY_STATS.
declare

  lv_batch_hr number;

  jn binary_integer;
  job_number number;

  CURSOR REM_BATCH_CUR IS
   select job from user_jobs
   where upper(what) in ('DW_PROCESS_BATCH_REQUESTS;','DW_REPORT_PENDING_REQUESTS;','DW_MONTHLY_STATS;');

  lv_pending_report_hr number;
begin
  FOR rem_batch_var in rem_batch_cur loop
    dbms_job.remove(rem_batch_var.job);    
    commit;
  end loop;

  lv_batch_hr:=dw_glob_var.gv_overnight_hour/24;
  lv_pending_report_hr:=dw_glob_var.gv_pending_report_hr/24;

 dbms_job.SUBMIT(jn,'DW_PROCESS_BATCH_REQUESTS;',trunc(sysdate) + lv_batch_hr,'trunc(sysdate+1) + '||lv_batch_hr);
    commit;

dbms_job.SUBMIT(jn,'DW_REPORT_PENDING_REQUESTS;',trunc(sysdate) + lv_pending_report_hr,'trunc(sysdate+1) + '||lv_pending_report_hr);
    commit;

--dbms_job.submit(jn,'DW_REPORT_PENDING_REQUESTS;',sysdate,'sysdate+(120/(24*60))');
--commit;

dbms_job.submit(jn,'DW_MONTHLY_STATS;',TRUNC(LAST_DAY(ADD_MONTHS(SYSDATE,-1))+1),
  'TRUNC(LAST_DAY(SYSDATE)+1)');
COMMIT;
end;
/

spool dw_schedule_batch_jobs.log

Prompt List of Batch Processing related scheduled jobs.

select job ||'   '||WHAT "Scheduled Jobs" from user_jobs
   where upper(what) in ('DW_PROCESS_BATCH_REQUESTS;','DW_REPORT_PENDING_REQUESTS;','DW_MONTHLY_STATS;');

spool off;